*** COS 2010, Lowess, last update 2023 06  
           
           
           
program dq_acc_tt1  
           
syntax varlist(max=1 numeric)  [if] [in], t(varname numeric) [obs(varname numeric) controlvars(string)]  										///  
       [gpath(string) gname(string) gwidth(int 500) gheight(int 375) labeldep(string) bwb(real 0.8) bcase(int 100) minobs(int 30) sdfac(real 2) lbound(real -9999) ubound(real 9999) ] ///  
	   [calc(int -1) lc(int 0) minevent(int 2) legend(int 1) minclustersize_icc(int 10) ststrata(string) stcluster(string) timetrendestimate(int 1)]	///  
	   [ indent(int 0) forcecalc(int 1)]  
marksample touse, novarlist  
           
           
           
if `indent'>0 local indent=`indent'+5  
local adoname "dq_acc_tt1"  
local text_i "di as text _n "  					  
           
preserve   
           
tempvar id 															  
tempvar sdlow sdlows sdlowsm sdhigh sdhighs sdhighsm 				  
local structure "`ststrata'_`stcluster'"  
           
if  "`obs'"=="" {  
	tempvar C_onstant  
	qui gen `C_onstant'=1  
	lab var `C_onstant' "Constant"  
	local obs "`C_onstant'"  
}          
           
           
qui capture reg `varlist' `obs' `controlvars' if `touse'  
if _rc==2000 local totalobs=0  
 else local totalobs=r(N)  
           
if `totalobs' < `minclustersize_icc' {  
	dq_out_etg , text("No sufficent observations in variable `varlist' with predictors: N=`r(N)'") savename("`graph_path'")   indent(`indent')  
	`text_i' "WARNING: function ended not normal   $S_TIME" _n(2)  
	exit      
}          
           
if `totalobs' >= `minclustersize_icc' & r(N) <= `minobs' {  
	dq_out_etg , text("Insufficent observations for useful lowess graph: N=`r(N)'") savename("`graph_path'")   indent(`indent')  
	`text_i' "WARNING: function ended not normal   $S_TIME" _n(2)  
	exit      
}          
           
           
qui levelsof `obs' if `touse'  		  
local clusternumber = wordcount("`r(levels)'")  
           
           
dq_hlp_fmt , clusternumber(`clusternumber')  indent(`indent')  
local gheight 			=`r(gheight)'  
local gwidth 			=`r(gwidth)'  
local textsize_y		=`r(textsize_y)'  
local textsize_x		=`r(textsize_x)'	  
local textlegendsize	=`r(textlegendsize)'	  
           
if `clusternumber'<=25 {  
    local yticks=10  
	local xticks=20  
}	         
           
if `clusternumber'>25 {  
	local yticks=20  
	local xticks=10  
}          
           
           
if "`gname'"=="" {  
	if `legend'==0 	local gname="lowess_`structure'_`varlist'"		  
		else local gname="lowess_`structure'_`varlist'"				  
}          
           
local graph_path "`gpath'\`gname'.png"  
scalar graph_tt1_`structure'_`pointer'="`graph_path'"  
           
           
           
capture confirm file "`graph_path'"				  
if (_rc==0 & `forcecalc'==0)  {  
	exit      
}          
           
           
           
qui levelsof `varlist' if `touse'  
local varlevels = wordcount("`r(levels)'")  
           
if `calc'==-1 {  
	if `varlevels'==1  {  
		dq_out_etg , text("No variance in outcome variable!") savename("`graph_path'")   indent(`indent')  
		exit		   
	}         
	if `varlevels'==2 {  
		local calc=1						  
	}         
	if `varlevels'>2  {  
		local calc=0						  
	}         
}	         
           
           
           
if `lc'==0 local legendcenter=`"xlabel(#20,angle(vertical)) ytitle("`labeldep'", angle(vertical))	graphregion(margin(vsmall) fcolor(white)) "'  
if `lc'==1 local legendcenter=`"xlabel(none) legend(position(0) ring(0)) ylabel(none) ytitle("")    graphregion(margin(vsmall) fcolor(white)) "'  
           
           
local controlvarlist=""  
if "`controlvars'"~="" {  
	dq_hlp_cov `controlvars' if `touse',  indent(`indent')  
	local controlvarlist="`r(controlvarlist)'"  
	local originalvarlist="`r(originalvarlist)'"  
}          
           
           
           
tempvar  dep 			  
if "`controlvarlist'"~="" {  
  tempvar res  			  
  if `calc'==1 {  
      qui clonevar `dep'= `varlist'  
  }        
  else {   
	  qui capture reg `varlist' `controlvarlist' if `touse'  
	  if _rc==2000 {  
		dq_out_add ,  tablename(integtable_analysisconduct) row(integtablerows_analysisconduct) columns(3) colcontent1("`varlist'") colcontent2("Lowess") colcontent3($DQ_INTP_issue_6)  indent(`indent')  
		exit     
	  }       
      qui predict `res', res					  
      qui sum `varlist'  
      qui gen `dep'= r(mean) + `res'  
  }        
}		        
else qui clonevar `dep'= `varlist'	  
           
           
qui tab `obs' if `touse', gen(o_b_s)  
local obslist o_b_s*  
local sample = r(N)			  
           
qui recode `obslist' (0=.)  
           
           
           
local n = 1  
local observernumber=0 		  
           
           
foreach observer of varlist `obslist' {  
	          
	          
	if `calc'==0 {  
		local regcom=""  
	}         
           
	if `calc'==1 {  
		local regcom="logit"  
		local labeldep="p"	  
	}         
           
	local calculate=1	  
	          
	qui count if `touse' &  `observer'==1 & `varlist'<.							  
	local obscount`n' = r(N)  
	if (`obscount`n'' <= `minobs' ) {  
		local calculate=0														  
		if (`obscount`n'' >= `minclustersize_icc' ) {  
			local calculate = -1		  
			local regcom=""  
			local labeldep=""	  
		}        
	}	        
	          
	          
	if `calc'==1 & `calculate'==1 {										  
		if `varlevels'==1  {											  
			qui sum `varlist' if `touse'  
					local calculate = -1	  
					local regcom=""  
					local labeldep=""  
		}        
		if `varlevels'==2 & `calculate'==1 {  
				qui prop `varlist' if `touse' & `observer'==1  
				mat def eb=e(b)  
				local casecount0 = trunc(eb[1,1]*e(df_r))				  
				local casecount1 = trunc(eb[1,2]*e(df_r))				  
				       
				if "`casecount1'"=="." local casecount1=0  
				       
				local mincasecount =min(`casecount0',`casecount1')  
				if  `mincasecount' <`minevent' local calculate=0  
				if `calculate'==0 {										  
					local calculate = -1	  
					local regcom=""  
					local labeldep=""			  
				}      
		}        
	}         
	          
	          
	qui sum `obs' if `touse' & `observer'==1  
	local onum=r(mean)  
	          
           
           
		         
	if  `calculate'==1 {			  
           
        local bw`n' = (`bcase')/(`obscount`n'')  
           
		tempvar op`n'					  
		local lowesscommandcall "lowess `dep' `t' if `touse' & `observer'==1, m  bwidth(`bw`n'') generate(`op`n'') nograph `regcom'"  
		if `calculate'==1  `lowesscommandcall'  
		if `calculate'==-1  reg `dep' `t' if `touse'  
		         
		if `calc'==1 & `calculate'==1 {  
    		qui replace `op`n''=exp(`op`n'')/(1+exp(`op`n''))				  
		}        
           
        * uebergabe Beobachterziffer an Variable  
		qui sum `obs' if `touse' & `observer'==1  
        local obsnum= r(mean)  
		lab var `op`n'' "`obsnum'"  
		         
		local graph`n' = "(connected `op`n'' `t', sort msize(small) lwidth(vthin) mcolor(${color`onum'}))"  
		         
		local observernumber=`n'  
		local n=`n'+1			  
		         
	}	        
	          
 }         
	          
           
           
if `observernumber'==0 {  
	dq_out_etg , text("Insufficent events for useful lowess graph, no observer was included") savename("`graph_path'")   indent(`indent')  
	capture drop o_b_s* 	  
	exit      
	`text_i' "WARNING:   $S_TIME" _n(2)  
}          
           
           
           
           
local calculate=1	  
           
	if `calc'==0 {  
		local regcom=""  
	}         
           
	if `calc'==1 {  
		local regcom="logit"  
		local labeldep="p"	  
	}         
           
qui levelsof `varlist' if `touse'  
local varlevels = wordcount("`r(levels)'")  
	          
           
if `calc'==1 & `calculate'==1 {							  
	if `varlevels'==1  {  
		qui sum `varlist' if `touse'  
		if r(max)==0 local calculate=2					  
		if r(max)==1 local calculate=3					  
	}         
	if `varlevels'==2 {  
			qui prop `varlist' if `touse'  
			mat def eb=e(b)  
			local casecount0 = trunc(eb[1,1]*e(df_r))	  
			local casecount1 = trunc(eb[1,2]*e(df_r))  
			local mincasecount =min(`casecount0',`casecount1')  
			if  `mincasecount' <`minevent' local calculate=0			  
			if  `mincasecount' <`minevent' {  
				local calculate=0  
				dq_out_etg , text("Insufficent events for useful lowess graph: N events=`mincasecount'") savename("`graph_path'")   indent(`indent')  
				capture drop o_b_s* 	  
				local calculate=0  
			}       
	}         
}          
           
           
if  `calculate'==1   {			  
           
           
	tempvar op0  
	qui lowess `dep' `t' if `touse', m  bwidth(0.4) generate(`op0') nograph `regcom'  
		if `calc'==1 {  
				qui replace `op0'=exp(`op0 & ')/(1+exp(`op0'))				  
		}        
	local graph0 = "(line `op0' `t', sort lwidth(thick) mcolor(gs5))"  
	lab var `op0' "Mean"  
           
	          
	local timetrendoutput ""											  
	capture confirm scalar tt1_tt_vp_`ststrata'_$`varlist'				  
	local ttscalar =_rc	  
	if `timetrendestimate'==1 {  
		if `ttscalar'>0 {  
			qui sum `op0' if `touse'  
			local meantrend_sd=r(sd)  
			qui sum `varlist' if `touse'  
			local meanall_sd=r(sd)  
			scalar tt1_tt_vp_`ststrata'_$`varlist'=`meantrend_sd'/`meanall_sd'  
		}        
	 	        
		dq_hlp_std ,  numstring("`=tt1_tt_vp_`ststrata'_$`varlist''") decimals(2)	 indent(`indent')	  
		local numstring="`r(numstring)'"  
		local timetrendoutput "$Timetrends_1, $Varianceproportion_1: `numstring'"	  
	}         
	          
	          
	          
           
	sort `t'  
	qui gen  `id'    =_n  
	qui gen  `sdlow' =.  
	qui gen  `sdhigh'=.  
           
           
           
	local j = 1  
	while `j'< `sample' {									 		  
	  qui sum `dep' if `touse' & `id'>`j'-80 & `id'<`j'+80  
	  local sds=r(sd)  
	  qui sum `op0' if `touse' & `id'==`j'  
	  qui replace `sdlow'=r(mean)-`sds'/`sdfac' if `touse' & `id'==`j'  
	  qui replace `sdhigh'=r(mean)+`sds'/`sdfac' if `touse' & `id'==`j'  
	  local ++j  
	}         
           
           
	tempvar sdlows  
	qui lowess `sdlow' `t' if `touse',   m  bwidth(0.4) generate(`sdlows') nograph `regcom'  
		if `calc'==1 {  
				qui replace `sdlows'=exp(`sdlows')/(1+exp(`sdlows'))				  
		}        
	tempvar sdhighs  
	qui lowess `sdhigh' `t' if `touse',  m  bwidth(0.4) generate(`sdhighs') nograph `regcom'  
		if `calc'==1 {  
				qui replace `sdhighs'=exp(`sdhighs')/(1+exp(`sdhighs'))				  
		}        
	lab var `sdlows'  "Mean -0.5 SD"  
	lab var `sdhighs' "Mean +0.5 SD"  
	local graphsdlow  = "(line  `sdlows'  `t', sort lwidth(medium) mcolor(gs5))"  
	local graphsdhigh = "(line  `sdhighs' `t', sort lwidth(medium) mcolor(gs5))"  
}          
           
           
 if  `calculate'==1  {  
           
           
	local graphlist ""  
	if `observernumber'>0 {		  
		forvalues n=1/`observernumber' {  
			local graphlist "`graphlist' `graph`n'' "  
		}        
	}         
           
*	if  "`controlvarlist'"~="" & `calc'==0  local cvtext `"text(100 100 "Control variables: `controlvarlist'", place(e) color(gs9) size(4) orientation(horizontal)) "'	  
	if  "`controlvarlist'"~="" & `calc'==0  local cvtext "Control variables: `originalvarlist'"	  
	if  "`controlvarlist'"~="" & `calc'==1  local cvtext "No control variables used with binary outcome."	  
           
	          
	if `legend' ==1 {  
		twoway   	`graphlist'																											///  
					`graph0' `graphsdlow' `graphsdhigh', 																				///  
					xlabel(#`xticks',angle(vertical) labsize(`textsize_x')) graphregion(margin(vsmall) fcolor($framecolor)) 			///  
					ylabel(#`yticks',angle(horizontal)   labsize(`textsize_y')  )  						 								///  
					`legendcenter' 																										///  
					title("$lowess_1", ring(0) position(5) size(`textlegendsize') box bcolor($framecolor)) 								///  
					caption("`timetrendoutput'; `cvtext'", size(`textlegendsize') box bcolor($framecolor)) 	  
	}         
           
	if `legend' ==0 {  
		twoway   	`graphlist'																											///  
					`graph0' `graphsdlow' `graphsdhigh' , 																				///  
					xlabel(#`xticks',angle(vertical) labsize(`textsize_x')) graphregion(margin(vsmall) fcolor($framecolor)) 			///  
					ylabel(#`yticks',angle(horizontal)   labsize(`textsize_y')  )  						 								///  
					ytitle("`labeldep'",  size(`textlegendsize') angle(vertical))														///  
					legend(off)	 																										///  
					title("$lowess_1", ring(0) position(5) size(`textlegendsize') box bcolor($framecolor)) 								///  
					caption("`timetrendoutput'; `cvtext'", size(`textlegendsize') box bcolor($framecolor)) 	  
	}         
           
	qui graph export "`graph_path'", replace width(`gwidth') height(`gheight')		  
}	         
		         
capture drop o_b_s* 	  
foreach var in `controlvarlist' {  
	if strpos("`var'","___")>0 qui drop `var'  
}          
           
restore    
           
end        
           
